<?= $this-> include('templates/header');?>
<main id="nsofts_main">
    <div class="nsofts-container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item d-inline-flex"><a href="dashboard.php"><i class="ri-home-4-fill"></i></a></li>
                <li class="breadcrumb-item d-inline-flex active" aria-current="page"><?= isset($pageTitle) ? esc($pageTitle) : "" ?></li>
            </ol>
        </nav>
        <div class="card">
            <div class="card-body p-0">                    
                <div class="nsofts-setting">
                    <div class="nsofts-setting__sidebar">
                        <div class="nav flex-column nav-pills" id="nsofts_setting" role="tablist" aria-orientation="vertical">
                            <button class="nav-link active" id="nsofts_setting_1" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_1" type="button" role="tab" aria-controls="nsofts_setting_1" aria-selected="true">
                                <i class="ri-list-settings-line"></i>
                                <span>General</span>
                            </button>
                            <button class="nav-link" id="nsofts_setting_2" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_2" type="button" role="tab" aria-controls="nsofts_setting_2" aria-selected="false">
                                <i class="ri-settings-5-line"></i>
                                <span>Sidebar</span>
                            </button>
                            <button class="nav-link" id="nsofts_setting_6" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_6" type="button" role="tab" aria-controls="nsofts_setting_6" aria-selected="false">
                                <i class="ri-contacts-line"></i>
                                <span>Contact us</span>
                            </button>
                            <button class="nav-link" id="nsofts_setting_5" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_5" type="button" role="tab" aria-controls="nsofts_setting_5" aria-selected="false">
                                <i class="ri-pages-line"></i>
                                <span>About Us</span>
                            </button>
                            <button class="nav-link" id="nsofts_setting_3" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_3" type="button" role="tab" aria-controls="nsofts_setting_3" aria-selected="false">
                                <i class="ri-survey-line"></i>
                                <span>Privacy Policy</span>
                            </button>
                            <button class="nav-link" id="nsofts_setting_4" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_4" type="button" role="tab" aria-controls="nsofts_setting_4" aria-selected="false">
                                <i class="ri-survey-line"></i>
                                <span>Terms & Conditions</span>
                            </button>
                            <a class="nav-link text-danger" href="https://web.nemosoftss.com/vox-radio/" target="_blank">
                                <i class="ri-global-line"></i>
                                <span>Demo Website</span>
                            </a>
                        </div>
                    </div>
                    <div class="nsofts-setting__content">
                        <div class="tab-content">
                            <!--General Settings-->
                            <div class="tab-pane fade show active" id="nsofts_setting_content_1" role="tabpanel" aria-labelledby="nsofts_setting_1" tabindex="0">
                                <form action="<?php echo base_url('/ns-admin/web_handler');?>" name="settings_general" method="POST" enctype="multipart/form-data">
                                     <?= csrf_field() ?>
                                    <h4 class="mb-4">General Settings</h4>

                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Site Name</label>
                                        <div class="col-sm-10">
                                           <input type="text" name="site_name" id="site_name" value="<?= isset($settings_data['site_name']) ? esc($settings_data['site_name']) : '' ?>"  class="form-control">
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Site Description</label>
                                        <div class="col-sm-10">
                                            <textarea rows="3" name="site_description" class="form-control" required=""><?= isset($settings_data['site_description']) ? esc($settings_data['site_description']) : '' ?></textarea>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Site Keywords</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="site_keywords" id="site_keywords" value="<?= isset($settings_data['site_keywords']) ? esc($settings_data['site_keywords']) : '' ?>"  class="form-control" required="required">
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Site Favicon</label>
                                        <div class="col-sm-10">
                                            <div class="row">
                                                <div class="col-md-5">
                                                    <input type="file" class="form-control-file" name="web_favicon" value="fileupload" accept=".png, .jpg, .JPG .PNG" onchange="fileValidation()" id="fileupload">
                                                    <p class="control-label-help hint_lbl">(Recommended resolution: 16x16 or 32x32)</p>
                                                </div>
                                                <div class="col-md-3">
                                                    <?php if($settings_data['web_favicon']!='') { ?>
                                                        <div class="fileupload_img" id="imagePreview">
                                                            <img  type="image" src="<?= isset($settings_data['web_favicon']) ? base_url('images/'.esc($settings_data['web_favicon'])) : base_url('assets/images/300x300.jpg') ?>" style="width: 50px;height: 50px"   alt="image" />
                                                        </div>
                                                    <?php }else{ ?>
                                                        <div class="fileupload_img" id="imagePreview">
                                                            <img type="image" src="<?= base_url('assets/images/300x300.jpg') ?>" style="width: 50px; height: 50px"  alt="image" />
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Site Logo</label>
                                        <div class="col-sm-10">
                                            <div class="row">
                                                <div class="col-md-5">
                                                    <input type="file" class="form-control-file" name="web_logo_1" value="fileupload2" accept=".png, .jpg, .JPG .PNG" onchange="fileValidation2()" id="fileupload2">
                                                    <p class="control-label-help hint_lbl">(Recommended resolution: 500x500)</p>
                                                </div>
                                                <div class="col-md-3">
                                                    <?php if($settings_data['web_logo_1']!='') { ?>
                                                        <div class="fileupload_img" id="imagePreview2">
                                                            <img  type="image" src="<?= isset($settings_data['web_logo_1']) ? base_url('images/'.esc($settings_data['web_logo_1'])) : base_url('assets/images/300x300.jpg') ?>" style="width: 50px;height: 50px"   alt="image" />
                                                        </div>
                                                    <?php }else{ ?>
                                                        <div class="fileupload_img" id="imagePreview2">
                                                            <img type="image" src="<?= base_url('assets/images/300x300.jpg') ?>" style="width: 50px; height: 50px"  alt="image" />
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Copyright Text</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="copyright_text" id="copyright_text" value="<?= isset($settings_data['copyright_text']) ? esc($settings_data['copyright_text']) : '' ?>"  class="form-control" required="required">
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Header Code</label>
                                        <div class="col-sm-10">
                                            <textarea rows="6" name="header_code" class="form-control"  placeholder="Custom CSS or JS Script" ><?= isset($settings_data['header_code']) ? esc($settings_data['header_code']) : '' ?></textarea>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Footer Code</label>
                                        <div class="col-sm-10">
                                            <textarea rows="6" name="footer_code" class="form-control" placeholder="Custom CSS or JS Script"><?= isset($settings_data['header_code']) ? esc($settings_data['footer_code']) : '' ?></textarea>
                                        </div>
                                    </div>
                                    
                                    <button type="submit" name="submit_general" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Web Sidebar-->
                            <div class="tab-pane fade" id="nsofts_setting_content_2" role="tabpanel" aria-labelledby="nsofts_setting_2" tabindex="0">
                                <h4 class="mb-4">Sidebar</h4>
                                <a href="<?= base_url('ns-admin/create-sidebar') ?>" class="btn btn-primary d-inline-flex align-items-center justify-content-center">
                                    <i class="ri-add-line"></i>
                                    <span class="ps-1 text-nowrap d-none d-sm-block">Create Sidebar</span>
                                </a>
                                </br>
                                </br>
                                <?php if(!empty($result)){ ?>
                                <div class="row">
                                   <?php $i=0; foreach($result as $row){ ?>
                                        <div class="col-lg-3 col-sm-6">
                                            <div class="nsofts-card-light p-3">
                                                <h5 class="mb-2"><?= isset($row['sidebar_title']) ? esc($row['sidebar_title']) : '' ?></h5></p>
                                                <div class="d-flex">
                                                    <a href="<?= base_url('ns-admin/create-sidebar/'.$row['id']) ?>" class="btn btn-outline-primary rounded-pill me-2 btn-icon" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                                        <i class="ri-pencil-line"></i>
                                                    </a>
                                                    <a href="javascript:void(0)" class="btn btn-outline-danger rounded-pill me-2 btn-icon btn_delete" data-action="<?= base_url('ns-admin/delete-sidebar/'.$row['id']) ?>" data-bs-toggle="tooltip" data-bs-placement="top" title="Delete">
                                                        <i class="ri-delete-bin-line"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php $i++; } ?>
                                </div>
                                <?php }else{ ?>
                                    <ul class="p-5">
                                        <h1 class="text-center">No data found</h1>
                                    </ul>
                                <?php } ?>
                            </div>
                            
                            <!--Privacy Policy-->
                            <div class="tab-pane fade" id="nsofts_setting_content_3" role="tabpanel" aria-labelledby="nsofts_setting_3" tabindex="0">
                                <form action="<?php echo base_url('/ns-admin/web_handler');?>" name="submit_privacy" method="POST" enctype="multipart/form-data">
                                     <?= csrf_field() ?>
                                    <h4 class="mb-4">Privacy Policy</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Page title</label>
                                        <div class="col-sm-10">
                                           <input type="text" name="privacy_page_title" id="privacy_page_title" value="<?= isset($settings_data['privacy_page_title']) ? esc($settings_data['privacy_page_title']) : '' ?>"  class="form-control">
                                        </div>
                                    </div>
                                    <div>
                                        <textarea name="privacy_content" id="privacy_content" rows="5" class="nsofts-editor mb-4">
                                            <?= isset($settings_data['privacy_content']) ? esc($settings_data['privacy_content']) : '' ?>
                                        </textarea>
                                    </div>
                                    <button type="submit" name="submit_privacy" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Terms & Conditions-->
                            <div class="tab-pane fade" id="nsofts_setting_content_4" role="tabpanel" aria-labelledby="nsofts_setting_4" tabindex="0">
                               <form action="<?php echo base_url('/ns-admin/web_handler');?>" name="settings_privacy"  method="POST" enctype="multipart/form-data">
                                    <?= csrf_field() ?>
                                    <h4 class="mb-4">Terms & Conditions</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Page title</label>
                                        <div class="col-sm-10">
                                           <input type="text" name="terms_of_use_page_title" id="terms_of_use_page_title" value="<?= isset($settings_data['terms_of_use_page_title']) ? esc($settings_data['terms_of_use_page_title']) : '' ?>"  class="form-control">
                                        </div>
                                    </div>
                                    <div>
                                        <textarea name="terms_of_use_content" id="terms_of_use_content" rows="5" class="nsofts-editor mb-4">
                                            <?= isset($settings_data['terms_of_use_content']) ? esc($settings_data['terms_of_use_content']) : '' ?>
                                        </textarea>
                                    </div>
                                    <button type="submit" name="submit_terms" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Contact us-->
                            <div class="tab-pane fade " id="nsofts_setting_content_6" role="tabpanel" aria-labelledby="nsofts_setting_6" tabindex="0">
                                <form action="<?php echo base_url('/ns-admin/web_handler');?>" name="submit_contact_us" method="POST" enctype="multipart/form-data">
                                     <?= csrf_field() ?>
                                    <h4 class="mb-4">Contact us</h4>
                                    
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">Address</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-map-pin-2-line"></i>
                                                </label>
                                                <input type="text" name="address" id="address" value="<?= isset($settings_data['address']) ? esc($settings_data['address']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">Contact number</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-phone-line"></i>
                                                </label>
                                                <input type="text" name="contact_number" id="contact_number" value="<?= isset($settings_data['contact_number']) ? esc($settings_data['contact_number']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">Contact email</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-mail-line"></i>
                                                </label>
                                                <input type="text" name="contact_email" id="contact_email" value="<?= isset($settings_data['contact_email']) ? esc($settings_data['contact_email']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">Android App Link</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-android-line"></i>
                                                </label>
                                                <input type="text" name="android_app_url" id="android_app_url" value="<?= isset($settings_data['android_app_url']) ? esc($settings_data['android_app_url']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">iOS App Link</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-app-store-line"></i>
                                                </label>
                                                <input type="text" name="ios_app_url" id="ios_app_url" value="<?= isset($settings_data['ios_app_url']) ? esc($settings_data['ios_app_url']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">Facebook</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-facebook-circle-line"></i>
                                                </label>
                                                <input type="text" name="facebook_url" id="facebook_url" value="<?= isset($settings_data['facebook_url']) ? esc($settings_data['facebook_url']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">Twitter</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-twitter-line"></i>
                                                </label>
                                                <input type="text" name="twitter_url" id="twitter_url" value="<?= isset($settings_data['twitter_url']) ? esc($settings_data['twitter_url']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">YouTube</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-youtube-line"></i>
                                                </label>
                                                <input type="text" name="youtube_url" id="youtube_url" value="<?= isset($settings_data['youtube_url']) ? esc($settings_data['youtube_url']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label class="col-sm-2 col-form-label">Instagram</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-input-icon nsofts-input-icon--left">
                                                <label for="home_limit" class="nsofts-input-icon__left">
                                                    <i class="ri-instagram-line"></i>
                                                </label>
                                                <input type="text" name="instagram_url" id="instagram_url" value="<?= isset($settings_data['instagram_url']) ? esc($settings_data['instagram_url']) : '' ?>"  class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" name="submit_contact_us" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--About Us-->
                            <div class="tab-pane fade" id="nsofts_setting_content_5" role="tabpanel" aria-labelledby="nsofts_setting_5" tabindex="0">
                                <form action="<?php echo base_url('/ns-admin/web_handler');?>" name="submit_about_us" method="POST" enctype="multipart/form-data">
                                     <?= csrf_field() ?>
                                    <h4 class="mb-4">About Us</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Page title</label>
                                        <div class="col-sm-10">
                                           <input type="text" name="about_page_title" id="about_page_title" value="<?= isset($settings_data['about_page_title']) ? esc($settings_data['about_page_title']) : '' ?>"  class="form-control">
                                        </div>
                                    </div>
                                    <div>
                                        <textarea name="about_content" id="about_content" rows="5" class="nsofts-editor mb-4">
                                            <?= isset($settings_data['about_content']) ? esc($settings_data['about_content']) : '' ?>
                                        </textarea>
                                    </div>
                                    <button type="submit" name="submit_about_us" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?= $this-> include('templates/footer');?>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const tabLinks = document.querySelectorAll('#nsofts_setting .nav-link');
        const tabContents = document.querySelectorAll('.tab-pane');
        
        // Load last active tab from localStorage
        const activeTab = localStorage.getItem('activeTabWeb') || '#nsofts_setting_content_1'; // Default to General tab
        const activeTabLink = document.querySelector(`#nsofts_setting [data-bs-target="${activeTab}"]`);
        const activeTabContent = document.querySelector(activeTab);
        
        // Check if the tab exists, otherwise fallback to General tab
        if (activeTabLink && activeTabContent) {
            tabLinks.forEach(link => link.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('show', 'active'));
            activeTabLink.classList.add('active');
            activeTabContent.classList.add('show', 'active');
        }

        // Listen for tab click events and save to localStorage
        tabLinks.forEach(link => {
            link.addEventListener('click', function () {
                const targetTab = this.getAttribute('data-bs-target');
                localStorage.setItem('activeTabWeb', targetTab);
            });
        });
    });
</script>

<script type="text/javascript">
    function fileValidation2(){
        var fileInput = document.getElementById('fileupload2');
        var filePath = fileInput.value;
        var allowedExtensions = /(\.png|.jpg)$/i;
        if(!allowedExtensions.exec(filePath)){
            if(filePath!='')
            fileInput.value = '';
            $.notify('Please upload file having extension .png, .jpg only!', { position:"top right",className: 'error'} ); 
            return false;
         }else {
            if (fileInput.files && fileInput.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $("#imagePreview2").find("img").attr("src", e.target.result);
                };
                reader.readAsDataURL(fileInput.files[0]);
            }
        }
    }
</script>